/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import java.util.Comparator;

public class DelayedRemovalArray<T>
extends Array<T> {
    private int iterating;
    private IntArray remove = new IntArray(0);

    public DelayedRemovalArray() {
    }

    public DelayedRemovalArray(Array array) {
        super(array);
    }

    public DelayedRemovalArray(boolean ordered, int capacity, Class arrayType) {
        super(ordered, capacity, arrayType);
    }

    public DelayedRemovalArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public DelayedRemovalArray(boolean ordered, T[] array, int startIndex, int count2) {
        super(ordered, array, startIndex, count2);
    }

    public DelayedRemovalArray(Class arrayType) {
        super(arrayType);
    }

    public DelayedRemovalArray(int capacity) {
        super(capacity);
    }

    public DelayedRemovalArray(T[] array) {
        super(array);
    }

    public void begin() {
        ++this.iterating;
    }

    public void end() {
        if (this.iterating == 0) {
            throw new IllegalStateException("begin must be called before end.");
        }
        --this.iterating;
        if (this.iterating == 0) {
            int n = this.remove.size;
            for (int i = 0; i < n; ++i) {
                this.removeIndex(this.remove.pop());
            }
        }
    }

    private void remove(int index2) {
        int n = this.remove.size;
        for (int i = 0; i < n; ++i) {
            int removeIndex = this.remove.get(i);
            if (index2 == removeIndex) {
                return;
            }
            if (index2 >= removeIndex) continue;
            this.remove.insert(i, index2);
            return;
        }
        this.remove.add(index2);
    }

    @Override
    public boolean removeValue(T value2, boolean identity) {
        if (this.iterating > 0) {
            int index2 = this.indexOf(value2, identity);
            if (index2 == -1) {
                return false;
            }
            this.remove(index2);
            return true;
        }
        return super.removeValue(value2, identity);
    }

    @Override
    public T removeIndex(int index2) {
        if (this.iterating > 0) {
            this.remove(index2);
            return this.get(index2);
        }
        return super.removeIndex(index2);
    }

    @Override
    public void removeRange(int start, int end) {
        if (this.iterating > 0) {
            for (int i = end; i >= start; --i) {
                this.remove(i);
            }
        } else {
            super.removeRange(start, end);
        }
    }

    @Override
    public void set(int index2, T value2) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.set(index2, value2);
    }

    @Override
    public void insert(int index2, T value2) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.insert(index2, value2);
    }

    @Override
    public void swap(int first, int second) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.swap(first, second);
    }

    @Override
    public T pop() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        return super.pop();
    }

    @Override
    public void clear() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.clear();
    }

    @Override
    public void sort() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.sort();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.sort(comparator);
    }

    @Override
    public void reverse() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.reverse();
    }

    @Override
    public void shuffle() {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.shuffle();
    }

    @Override
    public void truncate(int newSize) {
        if (this.iterating > 0) {
            throw new IllegalStateException("Invalid between begin/end.");
        }
        super.truncate(newSize);
    }

    public static <T> DelayedRemovalArray<T> with(T ... array) {
        return new DelayedRemovalArray<T>(array);
    }
}

